/*:
 * @plugindesc 核心系统相关。
*/
Game_Screen.prototype.showPicture = function (pictureId, name, origin, x, y,
    scaleX, scaleY, opacity, blendMode) {
    var realPictureId = this.realPictureId(pictureId);
    var picture = this._pictures[realPictureId]
    if(picture){
        picture.show(name, origin, x, y, scaleX, scaleY, opacity, blendMode);
        return
    }
    var picture = new Game_Picture();
    picture.show(name, origin, x, y, scaleX, scaleY, opacity, blendMode);
    this._pictures[realPictureId] = picture;
};

Game_Screen.prototype.erasePicture = function (pictureId) {
    var realPictureId = this.realPictureId(pictureId);
    this._pictures[realPictureId].erase();
};

Game_Screen.prototype.maxPictures = function () {
    return 16;
};

Game_Event.prototype.initialize = function (mapId, eventId) {
    Game_Character.prototype.initialize.call(this);
    this._mapId = mapId;
    this._eventId = eventId;
    this._once = false
    this.locate(this.event().x, this.event().y);
    this.refresh();
};

Game_Event.prototype.checkEventTriggerAuto = function () {
    if (this._trigger === 3&&!this._once) {
        this.start();
        this._once=true;
    }
};


// Window_ChoiceList.prototype.makeCommandList = function () {
//     var choices = $gameMessage.choices();
//     for (var i = 0; i < choices.length; i++) {
//         this.addCommand(choices[i], 'choice');
//     }
// };

Game_CharacterBase.prototype.realMoveSpeed = function () {
    return this._moveSpeed + (this.isDashing() ? 1.5 : 0);
};

window.$gameExtraData = null;
DataManager.createGameObjects = function () {
    $gameTemp = new Game_Temp();
    $gameSystem = new Game_System();
    $gameScreen = new Game_Screen();
    $gameTimer = new Game_Timer();
    $gameMessage = new Game_Message();
    $gameSwitches = new Game_Switches();
    $gameVariables = new Game_Variables();
    $gameSelfSwitches = new Game_SelfSwitches();
    $gameActors = new Game_Actors();
    $gameParty = new Game_Party();
    $gameTroop = new Game_Troop();
    $gameMap = new Game_Map();
    $gamePlayer = new Game_Player();
    $gameExtraData = new Game_ExtraData();
};

DataManager.makeSaveContents = function () {
    var contents = {};
    contents.system = $gameSystem;
    contents.screen = $gameScreen;
    contents.timer = $gameTimer;
    contents.switches = $gameSwitches;
    contents.variables = $gameVariables;
    contents.selfSwitches = $gameSelfSwitches;
    contents.actors = $gameActors;
    contents.party = $gameParty;
    contents.map = $gameMap;
    contents.player = $gamePlayer;
    contents.extraData = $gameExtraData;
    return contents;
};

DataManager.extractSaveContents = function (contents) {
    $gameSystem = contents.system;
    $gameScreen = contents.screen;
    $gameTimer = contents.timer;
    $gameSwitches = contents.switches;
    $gameVariables = contents.variables;
    $gameSelfSwitches = contents.selfSwitches;
    $gameActors = contents.actors;
    $gameParty = contents.party;
    $gameMap = contents.map;
    $gamePlayer = contents.player;
    $gameExtraData = contents.extraData;
};

Game_Event.prototype.meetsConditions = function (page) {
    var c = page.conditions;
    if (c.switch1Valid) {
        if (!$gameSwitches.value(c.switch1Id)) {
            return false;
        }
    }
    if (c.switch2Valid) {
        if (!$gameSwitches.value(c.switch2Id)) {
            return false;
        }
    }
    if (c.variableValid) {
        if (!$gameExtraData.checkSwitchValue($gameVariables.value(c.variableId), c.variableValue)) {
            return false;
        }
    }
    if (c.selfSwitchValid) {
        var key = [this._mapId, this._eventId, c.selfSwitchCh];
        if ($gameSelfSwitches.value(key) !== true) {
            return false;
        }
    }
    if (c.itemValid) {
        var item = $dataItems[c.itemId];
        if (!$gameParty.hasItem(item)) {
            return false;
        }
    }
    if (c.actorValid) {
        var actor = $gameActors.actor(c.actorId);
        if (!$gameParty.members().contains(actor)) {
            return false;
        }
    }
    return true;
};

Game_ExtraData.prototype.updateSwitchValue = function (swit, index, on) {
    var item = $gameVariables.value(swit)
    if (on) {
        $gameVariables.setValue(swit, item | (1 << (index - 1)))
    }
    else {
        $gameVariables.setValue(swit, item & ~(1 << (index - 1)))
    }
}

Game_ExtraData.prototype.checkSwitchValue = function (item, index) {
    return (item & (1 << (index - 1))) != 0
}
Game_ExtraData.prototype.checkSwitchValueWithIndex = function (index1, index2) {
    var item = $gameVariables.value(index1)
    return (item & (1 << (index2 - 1))) != 0
}

//记录
function Game_ExtraData() {
    this.initialize.apply(this, arguments);
}

Game_ExtraData.prototype.initialize = function () {
    this.initParam();
    this.resetTextFlag=true
    this.tempText=[]
    this.standBattle=null
};

//初始化数据集
Game_ExtraData.prototype.initParam = function () {
    this.specialStatusSet={
        futa:121,
        lock:122,
        brainwash:123,
        patch0:124,
        patch1:125,
        patch2:126,
        patch3:127,
        patch5:129,
        necklace:130,
        combatant:131
    }
    this.extraText = {
        CHI:{
            load:"加载",
            selectLang:"切换语言",
            choices:['传送至C区入口','传送至C区Boss点','传送至F区入口','传送至F区BOSS点','传送至B区入口','传送至B区BOSS点','传送至M区入口','传送至M区BOSS点','传送至H区收容房间','传送至H区BOSS点'],
            cancel:"取消",
            MSChoices:['关于玛茜','关于这座地城','关于地城的出现','*回想房间*','没事了','关于这些芯片','芯片合成','关于战斗员形态','关于温妮莎'],
            KNChoices:['关于秘密小路',"关于玛茜","关于电脑的调查","没事了",'关于战斗员形态'],
            status:{
                futa:"扶她化",
                lock:"贞操锁",
                brainwash:"洗脑进行",
                patch0:"催眠眼罩 0%",
                patch1:"催眠眼罩 30%",
                patch2:"催眠眼罩 55%",
                patch3:"催眠眼罩 90%",
                patch5:"洗脑完成",
                necklace:"干扰项圈",
                combatant:"战斗员化"
            },
            currentStatus:"当前状态"
        },
        JAP:{
            load:"ロード",
            selectLang: "言語を選択する",
            choices:['エリア C入り口へ移動します','エリア C終点へ移動します','エリア F入り口へ移動します','エリア F終点へ移動します','エリア B入り口へ移動します','エリア B終点へ移動します','エリア M入り口へ移動します','エリア M終点へ移動します','エリアHの収容室へ転送','エリア H終点へ移動します'],
            cancel:"キャンセル",
            MSChoices:['マシについて','このダンジョンについて','ダンジョンの出現について','*回想の部屋*','何でもない','これらのチップについて','チップ合成','戦闘員フォームについて','ウィネサについて'],
            KNChoices:['秘密の小道について',"マシについて","コンピュータの調査について","何でもない",'戦闘員フォームについて'],
            status:{
                futa:"ふたなり",
                lock:"貞操帯",
                brainwash:"洗脳進行中",
                patch0:"洗脳進捗 0%",
                patch1:"洗脳進捗 30%",
                patch2:"洗脳進捗 55%",
                patch3:"洗脳進捗 90%",
                patch5:"洗脳完了",
                necklace:"干渉首輪",
                combatant:"戰鬥員化"
            },

            currentStatus:"現在の状態"
        }
    }

    this.choicesMS=[true,false,false,true,true,true,false,false,false]
    this.choicesKN=[true,true,true,true,false]
}

Game_ExtraData.prototype.registerStandBattle=function(obj){
    this.standBattle=obj
}

Game_ExtraData.prototype.removeStandBattle=function(){
    this.standBattle=null
}

Game_ExtraData.prototype.initParamInHScene = function () {
    this.HParam = {
    }
}

Window_Base.prototype.standardFontFace = function () {
    if ($gameSystem.isChinese()) {
        return 'GameFont, SimHei, Heiti TC, sans-serif';
    } else if ($gameSystem.isKorean()) {
        return 'Dotum, AppleGothic, sans-serif';
    } else {
        return 'GameFont';
    }
};

Game_ExtraData.prototype.resetItemText=function(language){
    if(language=="CHI"){
        // let Reg=/\<C\:.+\>/
        $dataItems.forEach(item=>{
            if(item==null)
                return
            if(item.meta.C)
                item.name=item.meta.C
            if(item.meta.CD)
                item.description=item.meta.CD
        })
        $dataArmors.forEach(item=>{
            if(item==null)
                return
            if(item.meta.C)
                item.name=item.meta.C
            if(item.meta.CD)
                item.description=item.meta.CD
        }
        )
    }
    else {
        $dataItems.forEach(item => {
            if (item == null)
                return
            if (item.meta.J)
                item.name = item.meta.J
            if(item.meta.JD)
                item.description=item.meta.JD
        }
        )
        $dataArmors.forEach(item => {
            if (item == null)
                return
            if (item.meta.J)
                item.name = item.meta.J
            if(item.meta.JD)
                item.description=item.meta.JD
        })
    }
}
Game_ExtraData.prototype.resetSkillText = function (language) {
    if (language == "CHI") {
        $dataSkills.forEach(item => {
            if (item == null)
                return
            if (item.meta.C)
                item.name = item.meta.C
            if (item.meta.CMSG1)
                item.message1 = item.meta.CMSG1
            if (item.meta.CMSG2)
                item.message2 = item.meta.CMSG2
            if(item.meta.CD)
                item.description=item.meta.CD
        }
        )
    }
    else {
        $dataSkills.forEach(item => {
            if (item == null)
                return
            if (item.meta.J)
                item.name = item.meta.J
            if (item.meta.JMSG1)
                item.message1 = item.meta.JMSG1
            if (item.meta.JMSG2)
                item.message2 = item.meta.JMSG2
            if(item.meta.JD)
                item.description=item.meta.JD
        }
        )
    }
}

Game_ExtraData.prototype.resetEnemyText = function(language) {
    $dataEnemies.forEach(enemy => {
        if (!enemy) return;

        if (language === "CHI") {
            if (enemy.meta.C)
                enemy.name = enemy.meta.C;
            if (enemy.meta.CD)
                enemy.description = enemy.meta.CD; 
        }
        else {
            if (enemy.meta.J)
                enemy.name = enemy.meta.J;
            if (enemy.meta.JD)
                enemy.description = enemy.meta.JD;
        }
    });
};

Game_ExtraData.prototype.resetStateText = function(language) {
    if (language === "CHI") {
        $dataStates.forEach(state => {
            if (!state) return;

            if (state.meta.C)
                state.name = state.meta.C;
            if (state.meta.CMSG1)
                state.message1 = state.meta.CMSG1;
            if (state.meta.CMSG2)
                state.message2 = state.meta.CMSG2;
            if (state.meta.CMSG3)
                state.message3 = state.meta.CMSG3;
            if (state.meta.CMSG4)
                state.message4 = state.meta.CMSG4;
            if (state.meta.CD)
                state.description = state.meta.CD;
        });
    } else {
        $dataStates.forEach(state => {
            if (!state) return;

            if (state.meta.J)
                state.name = state.meta.J;
            if (state.meta.JMSG1)
                state.message1 = state.meta.JMSG1;
            if (state.meta.JMSG2)
                state.message2 = state.meta.JMSG2;
            if (state.meta.JMSG3)
                state.message3 = state.meta.JMSG3;
            if (state.meta.JMSG4)
                state.message4 = state.meta.JMSG4;
            if (state.meta.JD)
                state.description = state.meta.JD;
        });
    }
};

Game_ExtraData.prototype.resetSkillTypeText = function(language) {
    if (!$dataSystem || !$dataClasses) return;

     let skillTypeCHI = {};
    let skillTypeJAP = {};

     $dataClasses.forEach(cls => {
        if (!cls) return;

        for (let key in cls.meta) {
            // CHI
            if (key.startsWith("ST") && key.endsWith("_C")) {
                let id = Number(key.match(/ST(\d+)_C/)[1]);
                skillTypeCHI[id] = cls.meta[key];
            }
            // JAP
            if (key.startsWith("ST") && key.endsWith("_J")) {
                let id = Number(key.match(/ST(\d+)_J/)[1]);
                skillTypeJAP[id] = cls.meta[key];
            }
        }
    });

     if (language === "CHI") {
        for (let id in skillTypeCHI) {
            $dataSystem.skillTypes[id] = skillTypeCHI[id];
        }
    } else {
        for (let id in skillTypeJAP) {
            $dataSystem.skillTypes[id] = skillTypeJAP[id];
        }
    }

     $gameParty.members().forEach(actor => {
        actor._skillTypes = null;
    });
};

Game_ExtraData.prototype.resetSystemText = function (language) {
        this.resetTextFlag = false
        var xhr = new XMLHttpRequest();
        var url = `data/${language}/System.json`;
        xhr.open('GET', url);
        xhr.overrideMimeType('application/json');
        xhr.onload = ()=>{
            this.resetTextFlag = true
            if (xhr.status < 400) {
                obj = JSON.parse(xhr.responseText);
                $dataSystem.terms=obj
            if (obj.gameTitle)
                $dataSystem.gameTitle = obj.gameTitle;
            if (obj.currencyUnit)
                $dataSystem.currencyUnit = obj.currencyUnit;
            }
        };
        xhr.send();
}

Game_ExtraData.prototype.resetCharacterName = function (language) {
    let name =['柯蕾丝',"里花",'クリスタル','里花']
    let flag=0
    if(language=='JAP'){
        flag+=2
    }
    if(!$gameSwitches.value(101)){
        flag++
    }
    $gameActors.actor(1).setName(name[flag])
}

Game_ExtraData.prototype.resetCurrencyUnit = function(language) {
    if (language === "CHI") {
        $dataSystem.currencyUnit = "破碎芯片";
    } else {
        $dataSystem.currencyUnit = "チップの破片";
    }
};

Game_Interpreter.prototype.transport=function(index){
    let originPoint=[{mapId:19,x:55,y:35,d:8,index:0},
                     {mapId:15,x:13,y:24,d:8,index:1},
                     {mapId:10,x:14,y:33,d:4,index:2},
                     {mapId:14,x:8,y:23,d:8,index:3},
                     {mapId:18,x:78,y:13,d:8,index:4},
                     {mapId:29,x:19,y:23,d:8,index:5},
                     {mapId:32,x:48,y:8,d:2,index:6},
                     {mapId:34,x:4,y:24,d:6,index:7},
                     {mapId:44,x:7,y:4,d:2,index:8},
                     {mapId:39,x:28,y:23,d:2,index:9},]

    let newPoint = originPoint.filter(item => {
        return $gameExtraData.checkSwitchValueWithIndex(4, item.index);
    });

    let choices = newPoint.map(item => {
        return $gameExtraData.extraText[ConfigManager.Language].choices[item.index];
    });

    const cancelText = $gameExtraData.extraText[ConfigManager.Language].cancel;
    choices.push(cancelText);

    $gameMessage.setChoices(choices, 0, -1);
    $gameMessage.setChoiceCallback(n => {

        if (n === choices.length - 1) return;

        let obj = newPoint[n];
        $gamePlayer.reserveTransfer(obj.mapId, obj.x, obj.y, obj.d, 0);
        this.setWaitMode('transfer');
    });

    this.setWaitMode('message');
}

Window_MenuStatus.prototype.drawAllItems = function() {
    Window_Selectable.prototype.drawAllItems.call(this)
    this.drawSpeicialStatus()
    this.drawTachie()
};

Window_MenuStatus.prototype.drawSpeicialStatus = function () {
    var rect = this.itemRect(3);
    let x = rect.x + 20;
    let y = rect.y;
    let extraText = $gameExtraData.extraText[ConfigManager.Language];

    this.changeTextColor(this.systemColor());
    this.drawText(extraText.currentStatus + ":", x, y, 200, 'left');

    this.changeTextColor(this.normalColor());
    let list = [];
    for (let key in $gameExtraData.specialStatusSet) {
        let indexOfSwitch = $gameExtraData.specialStatusSet[key];
        if ($gameSwitches.value(indexOfSwitch)) {
            list.push(extraText.status[key]);
        }
    }

    let lineHeight = this.lineHeight();
    let statusX = x + (ConfigManager.Language === "CHI" ? 140 : 160);
    let firstY  = y; 

    if (list.length === 0) {
        this.drawText("无", statusX, firstY, 200, 'left');
        return;
    }
    this.drawText(list[0], statusX, firstY, 200, 'left');
    for (let i = 1; i < list.length; i++) {
        this.drawText(list[i], statusX, firstY + lineHeight * i, 200, 'left');
    }
};

Window_MenuStatus.prototype.drawTachie=function(){
    this._sprite=new Sprite_Stand()
    this._sprite.position=new Point(300,-64)
    this.addChild(this._sprite)
}

Game_Interpreter.prototype.talkWith = function (obj) {
    $gameMessage.add("\\CC<0>")
    const choices=[]
    const jumpLabels=[]
    let target=`choices${obj}`
    let targetChoice=`${obj}Choices`
    $gameExtraData[target].forEach((item,index)=>{
        if(item){
            choices.push($gameExtraData.extraText[ConfigManager.Language][targetChoice][index])
            jumpLabels.push($gameExtraData.extraText.CHI[targetChoice][index])
        }
    })
    $gameMessage.setChoices(choices, 0, -1);
    $gameMessage.setChoiceCallback(n => {
        this.jumpLabel(jumpLabels[n])
    })
    this.setWaitMode('message');
}

Game_Interpreter.prototype.jumpLabel=function(labelName){
    for (var i = this._index; i < this._list.length; i++) {
        var command = this._list[i];
        if (command.code === 118 && command.parameters[0] === labelName) {
            this.jumpTo(i);
            return;
        }
    }
}

